package com.ejie.aa94a.utils;

import com.ejie.aa94a.model.calculo.Resultado;

/**
 * Clase de utilidades para PDF
 * 
 * 
 * Formateamos los campos que vamos a mostrar en el pdf
 * 
 * @author GFI
 * 
 */
public class UtilFormatResultado {

	/**
	 * Constructor de UtilFormatResultado
	 */
	private UtilFormatResultado() {
	}

	/**
	 * CREAMOS LA RUTA Y NOMBRE DEL FICHERO DEPENDIENDO DEL TIPO DE RESOLUCION
	 * 
	 * @param ruta
	 *            String
	 * @param nombre
	 *            String
	 * @param extension
	 *            String
	 * @param resultado
	 *            Resultado
	 * @return String
	 */
	public static String generateRutaPdf(String ruta, String nombre,
			String extension, Resultado resultado) {

		String rutaAux = UtilFormatResultado.generateTituloPdf(ruta, nombre,
				extension, 123456L/* cambiar */);

		return rutaAux;

	}

	/**
	 * 
	 * Generamos el nombre del pdf en base a las fechas de la resolucion
	 * 
	 * tipoDoc_idProceso_fechadesde_fechahasta
	 * 
	 * @param ruta
	 *            String
	 * @param nombre
	 *            String
	 * @param extension
	 *            String
	 * @param idPrestamo
	 *            Long
	 * @return String
	 */
	public static String generateTituloPdf(String ruta, String nombre,
			String extension, Long idPrestamo) {

		StringBuilder tituloPDF = new StringBuilder();
		StringBuffer dir = new StringBuffer(ruta);

		tituloPDF.append(dir.toString()).append(nombre)
				.append(String.valueOf(idPrestamo)).append(extension);

		return tituloPDF.toString();
	}
}